//------------------------------------------------------------------------------
// File: WaitForTarget.cs
// Contains the WaitForTarget AI state node implementation
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Called when WaitForTarget is entered
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_WaitForTarget::OnEnter(%this, %cmpAI)
{
   // Stop the object from moving
   StopMoving(%cmpAI);
   
   // Get object identifier
   %object = GetThisObject(%cmpAI);
   
   // Play root correct animation
   %cmpChar = slgQueryInterface(%object, $CID_CHARACTER);
   if(isObject(%cmpChar)) {
      if(%cmpChar.inState($CharacterState::Drunk)) {
         %object.playThread(0, "drunkroot");
      }
      else {
         %object.playThread(0, "root");
      }
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Called when WaitForTarget is exited
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_WaitForTarget::OnExit(%this, %cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Called every update while in WaitForTarget
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_WaitForTarget::Update(%this, %cmpAI)
{
   // Wait for target or play idle
   if(TargetHasArrived(%cmpAI, GetParameterTarget(%cmpAI))) {
      // Play arrest sound
      %object  = GetThisObject(%cmpAI);
      %cmpChar = slgQueryInterface(%object, $CID_CHARACTER);
      if(isObject(%cmpChar)) {
         if(%cmpChar.inState($CharacterState::Drunk)) {
            svrPlaySFXSound(audio_arrestdrunk);
         }
      }
      ReturnValue(%cmpAI, 0);
   }
   else if(TimeInNode(%cmpAI) >= 10) {
      ReturnValue(%cmpAI, 1);
   }
   else {
      ReturnValue(%cmpAI, -1);
   }
   return;
}

// End WaitForTarget.cs